//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.ui.theme](../index.md)/[Dimensions](index.md)

# Dimensions

class [Dimensions](index.md)(val border: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 1.dp, val thickBorder: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 2.dp, val inset: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val widthWindowSizeClass: [WindowWidthSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowWidthSizeClass.html) = WindowWidthSizeClass.Compact, val heightWindowSizeClass: [WindowHeightSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowHeightSizeClass.html) = WindowHeightSizeClass.Compact, val imagePreviewSize: [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) = Size(width = 178f, height = 152f), val videoPreviewSize: [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) = Size(width = 178f, height = 152f), val grid: [GridDimensionSet](../-grid-dimension-set/index.md), val staticGrid: [GridDimensionSet](../-grid-dimension-set/index.md) = staticGridPreset)

Dimensions that drive spacing and padding within Components

#### Parameters

common

| | |
|---|---|
| border | Thickness of a border. |
| thickBorder | Thickness of a thick border. |
| inset | Spacing from edge of screen to content. |
| widthWindowSizeClass | size class for the width of the device. |
| heightWindowSizeClass | size class for the height of the device. |
| imagePreviewSize | Preview size for image attachments in chat. |
| videoPreviewSize | Preview size for video attachments in chat. |

## Constructors

| | |
|---|---|
| [Dimensions](-dimensions.md) | [common]<br>constructor(border: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 1.dp, thickBorder: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 2.dp, inset: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), widthWindowSizeClass: [WindowWidthSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowWidthSizeClass.html) = WindowWidthSizeClass.Compact, heightWindowSizeClass: [WindowHeightSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowHeightSizeClass.html) = WindowHeightSizeClass.Compact, imagePreviewSize: [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) = Size(width = 178f, height = 152f), videoPreviewSize: [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) = Size(width = 178f, height = 152f), grid: [GridDimensionSet](../-grid-dimension-set/index.md), staticGrid: [GridDimensionSet](../-grid-dimension-set/index.md) = staticGridPreset) |

## Properties

| Name | Summary |
|---|---|
| [border](border.md) | [common]<br>val [border](border.md): [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) |
| [grid](grid.md) | [common]<br>val [grid](grid.md): [GridDimensionSet](../-grid-dimension-set/index.md)<br>Material design has grid spacings by 4dp increments for normal use cases This field is dynamically sized based on screen size |
| [heightWindowSizeClass](height-window-size-class.md) | [common]<br>val [heightWindowSizeClass](height-window-size-class.md): [WindowHeightSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowHeightSizeClass.html) |
| [imagePreviewSize](image-preview-size.md) | [common]<br>val [imagePreviewSize](image-preview-size.md): [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) |
| [inset](inset.md) | [common]<br>val [inset](inset.md): [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) |
| [isLargeWidth](is-large-width.md) | [common]<br>val [isLargeWidth](is-large-width.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isMediumWidth](is-medium-width.md) | [common]<br>val [isMediumWidth](is-medium-width.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [staticGrid](static-grid.md) | [common]<br>val [staticGrid](static-grid.md): [GridDimensionSet](../-grid-dimension-set/index.md)<br>A static grid that is screen size independent based on Material design 4dp spacing |
| [thickBorder](thick-border.md) | [common]<br>val [thickBorder](thick-border.md): [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) |
| [videoPreviewSize](video-preview-size.md) | [common]<br>val [videoPreviewSize](video-preview-size.md): [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) |
| [widthWindowSizeClass](width-window-size-class.md) | [common]<br>val [widthWindowSizeClass](width-window-size-class.md): [WindowWidthSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowWidthSizeClass.html) |
